<?php
if (!defined('ABSPATH')) exit;

add_action('admin_menu', function() {
    add_menu_page(
        'SentraSystems',
        'SentraSystems',
        'manage_options',
        'sentrasystems',
        'sentra_admin_page',
        'dashicons-cloud'
    );
});

function sentra_admin_page() {
    ?>
    <div class="wrap">
        <h1>SentraSystems Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('sentrasystems_group');
            do_settings_sections('sentrasystems');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

add_action('admin_init', function() {

    register_setting('sentrasystems_group', 'sentrasystems_settings');

    add_settings_section('sentra_main', '', null, 'sentrasystems');

    $fields = [
        'base' => 'API Base URL',
        'media_base' => 'Media Base URL',
        'auth_base' => 'Auth Base URL',
        'auth_public_base' => 'Auth Public URL (Branded/OAuth)',
        'portal_url' => 'Client Portal URL',
        'staff_portal_url' => 'Staff Portal URL',
        'quote_url' => 'Quote/Chat URL',
        'tenant_id' => 'Tenant ID',
        'auth_tenant_id' => 'Auth Tenant ID',
        'tenant_badge' => 'Tenant Badge',
        'staff_badge' => 'Staff Badge',
        'site_id' => 'Site ID',
        'secret' => 'Site Secret',
        'cache_ttl' => 'Cache TTL (seconds)',
        'telemetry_url' => 'Telemetry URL',
        'ai_base' => 'AI Base URL',
        'signage_manager_url' => 'Signage Manager URL',
        'signage_player_base' => 'Signage Player Base URL',
        'signage_device_id' => 'Signage Device ID',
        'signage_device_token' => 'Signage Device Token',
    ];

    foreach ($fields as $key => $label) {
        add_settings_field($key, $label, function() use ($key) {
            $options = get_option('sentrasystems_settings', []);
            echo '<input type="text" style="width:400px" name="sentrasystems_settings['.$key.']" value="'.esc_attr($options[$key] ?? '').'">';
        }, 'sentrasystems', 'sentra_main');
    }

    add_settings_field('badge_enabled', 'Show Sentra badge', function() {
        $options = get_option('sentrasystems_settings', []);
        $enabled = !empty($options['badge_enabled']);
        echo '<input type="hidden" name="sentrasystems_settings[badge_enabled]" value="0">';
        echo '<label style="display:flex;align-items:center;gap:8px;">';
        echo '<input type="checkbox" name="sentrasystems_settings[badge_enabled]" value="1" '.checked($enabled, true, false).'>';
        echo '<span>Show the Sentra Systems development badge on the site.</span>';
        echo '</label>';
    }, 'sentrasystems', 'sentra_main');

    add_settings_field('badge_message', 'Badge message', function() {
        $options = get_option('sentrasystems_settings', []);
        $value = $options['badge_message'] ?? '';
        echo '<textarea name="sentrasystems_settings[badge_message]" rows="3" style="width:400px;">'.esc_textarea($value).'</textarea>';
    }, 'sentrasystems', 'sentra_main');

    add_settings_field('ai_enabled', 'Enable AI intake', function() {
        $options = get_option('sentrasystems_settings', []);
        $enabled = !array_key_exists('ai_enabled', $options) || !empty($options['ai_enabled']);
        echo '<input type="hidden" name="sentrasystems_settings[ai_enabled]" value="0">';
        echo '<label style="display:flex;align-items:center;gap:8px;">';
        echo '<input type="checkbox" name="sentrasystems_settings[ai_enabled]" value="1" '.checked($enabled, true, false).'>';
        echo '<span>Allow the contact form to send intake to the Sentra AI service.</span>';
        echo '</label>';
    }, 'sentrasystems', 'sentra_main');
});
