<?php
/**
 * Plugin Name: SentraSystems
 * Plugin URI: https://sentrasys.dev
 * Description: Official Sentra Systems connector for WordPress tenants.
 * Version: 1.0.1
 * Author: Sentra Systems
 * Author URI: https://sentrasys.dev
 */

if (!defined('ABSPATH')) exit;

define('SENTRASYSTEMS_VERSION', '1.0.1');
define('SENTRASYSTEMS_PATH', plugin_dir_path(__FILE__));
define('SENTRASYSTEMS_URL', plugin_dir_url(__FILE__));

require_once SENTRASYSTEMS_PATH . 'includes/config.php';
require_once SENTRASYSTEMS_PATH . 'includes/api.php';
require_once SENTRASYSTEMS_PATH . 'includes/public.php';
require_once SENTRASYSTEMS_PATH . 'includes/services.php';
require_once SENTRASYSTEMS_PATH . 'includes/gallery.php';
require_once SENTRASYSTEMS_PATH . 'includes/partners.php';
require_once SENTRASYSTEMS_PATH . 'includes/auth.php';
require_once SENTRASYSTEMS_PATH . 'includes/ai.php';
require_once SENTRASYSTEMS_PATH . 'includes/admin.php';
require_once SENTRASYSTEMS_PATH . 'includes/updater.php';
new SentraSystems_Plugin_Updater();

function sentrasystems_auth_ui_disabled() {
	$disabled = false;
	if (defined('SENTRASYSTEMS_DISABLE_AUTH_UI') && SENTRASYSTEMS_DISABLE_AUTH_UI) {
		$disabled = true;
	}
	if (function_exists('moores_render_auth_modal')) {
		$disabled = true;
	}
	return (bool) apply_filters('sentrasystems_disable_auth_ui', $disabled);
}

/**
 * Back-compat aliases (your theme currently calls these)
 * Prevents fatals like "undefined function sentra_public_data()"
 */
if (!function_exists('sentra_public_data')) {
	function sentra_public_data($force = false) {
		return function_exists('sentrasystems_public_data') ? sentrasystems_public_data($force) : [];
	}
}
if (!function_exists('sentra_config')) {
	function sentra_config() {
		return function_exists('sentrasystems_config') ? sentrasystems_config() : [];
	}
}

/**
 * Enqueue plugin assets + localize config for JS
 */
function sentrasystems_enqueue_assets() {
	if (sentrasystems_auth_ui_disabled()) {
		return;
	}
	$cfg = function_exists('sentrasystems_config') ? sentrasystems_config() : [];

	// CSS (keep minimal, inherits theme look; you can override in theme)
	wp_enqueue_style(
		'sentrasystems-auth',
		SENTRASYSTEMS_URL . 'assets/auth.css',
		[],
		SENTRASYSTEMS_VERSION
	);

	// JS
	wp_enqueue_script(
		'sentrasystems-auth',
		SENTRASYSTEMS_URL . 'assets/auth.js',
		[],
		SENTRASYSTEMS_VERSION,
		true
	);

	wp_localize_script('sentrasystems-auth', 'SentraAuth', [
		'ajax_url'   => admin_url('admin-ajax.php'),
		'nonce'      => wp_create_nonce('sentrasystems_auth'),
		'tenant_id'  => $cfg['tenant_id'] ?? '',
		'portal_url' => $cfg['portal_url'] ?? '',
		// server targets (used by PHP; still helpful to show in debug)
		'base'       => $cfg['base'] ?? '',
		'auth_base'  => $cfg['auth_base'] ?? '',
		'auth_public_base' => $cfg['auth_public_base'] ?? '',
	]);
}
add_action('wp_enqueue_scripts', 'sentrasystems_enqueue_assets', 20);

function sentrasystems_enqueue_badge_assets() {
	if (is_admin()) return;
	$cfg = function_exists('sentrasystems_config') ? sentrasystems_config() : [];
	if (empty($cfg['badge_enabled'])) return;
	wp_enqueue_style(
		'sentrasystems-badge',
		SENTRASYSTEMS_URL . 'assets/badge.css',
		[],
		SENTRASYSTEMS_VERSION
	);
}
add_action('wp_enqueue_scripts', 'sentrasystems_enqueue_badge_assets', 30);

/**
 * Render login modal HTML globally (so header buttons always work)
 */
function sentrasystems_render_auth_modal() {
	if (sentrasystems_auth_ui_disabled()) {
		return;
	}
	?>
	<div class="sentra-auth-modal" id="sentra-auth-modal" aria-hidden="true">
		<div class="sentra-auth-backdrop" data-auth-close></div>

		<div class="sentra-auth-dialog" role="dialog" aria-modal="true" aria-labelledby="sentra-auth-title">
			<button class="sentra-auth-x" type="button" data-auth-close aria-label="Close">×</button>

			<h3 id="sentra-auth-title" class="sentra-auth-title">Client Login</h3>

			<form id="sentra-login-form" class="sentra-auth-form">
				<label class="sentra-auth-label">
					<span>Email or Username</span>
					<input type="text" name="email" autocomplete="username" required>
				</label>

				<label class="sentra-auth-label">
					<span>Password</span>
					<input type="password" name="password" autocomplete="current-password" required>
				</label>

				<button class="sentra-auth-submit" type="submit">Login</button>

				<p class="sentra-auth-msg" id="sentra-auth-msg" aria-live="polite"></p>

				<?php
				// Optional: show portal link if you configured it
				$cfg = function_exists('sentrasystems_config') ? sentrasystems_config() : [];
				if (!empty($cfg['portal_url'])) :
				?>
					<p class="sentra-auth-sub">
						Or open portal: <a href="<?php echo esc_url($cfg['portal_url']); ?>" class="sentra-auth-link">Client Portal</a>
					</p>
				<?php endif; ?>
			</form>
		</div>
	</div>
	<?php
}
add_action('wp_footer', 'sentrasystems_render_auth_modal', 50);

function sentrasystems_render_badge() {
	if (is_admin()) return;
	$cfg = function_exists('sentrasystems_config') ? sentrasystems_config() : [];
	if (empty($cfg['badge_enabled'])) return;
	$message = isset($cfg['badge_message']) ? trim((string) $cfg['badge_message']) : '';
	if ($message === '') {
		$message = 'In development — limited functionality. Powered by Sentra Systems.';
	}
	?>
	<div class="sentra-badge" role="note" aria-live="polite">
		<div class="sentra-badge__brand">Sentra Systems</div>
		<div class="sentra-badge__text"><?php echo esc_html($message); ?></div>
	</div>
	<?php
}
add_action('wp_footer', 'sentrasystems_render_badge', 90);
